﻿var variableSelector = {
    surveyId: 0,
    datatable: null,
    showSystemVariables: false,
    showEditableSystemVariables: false,
    onlyOpenEnds: false,
    showFilters: false,
    limitRowCount: 10,
    initializeDataTable: function () {
        var selectedVariables = $(".v-selectedVariables").val();

        if (!selectedVariables || selectedVariables.length == 0) {
            var variableEditor = a4.parent($(".v-selectedVariables")).variableEditor;

            if (variableEditor && variableEditor.currentData != null && variableEditor.currentData != "") {
                selectedVariables = _.pluck($.parseJSON(variableEditor.currentData), "Name").join(",");
            }
        }

        this.datatable = $(".h-variables-table").a4datatable({
            ajaxAction: a4.getSurveyAction("GetVariables", "Shared"),
            ajaxParams: { "includeSystemVariables": variableSelector.showSystemVariables, "includeEditableSystemVariables": variableSelector.showEditableSystemVariables, "onlyOpenEnds": variableSelector.onlyOpenEnds },
            columns: [
                { "Name": "Name", "Data": "Name", "Visible": false, "HideInSelector": true, "Key": true },
                { "Name": "Position", "Title": resources.QuestionNumber, "Data": "Position" },
                { "Name": "Id", "Title": resources.Id, "Data": "Id", render: function (data) { return data > 0 ? data : "" } },
                { "Name": "DisplayName", "Title": resources.VariableName, "Data": "DisplayName", "Width": "30%" },
                { "Name": "QuestionName", "Title": resources.QuestionType, "Data": "QuestionName", "Width": "30%" },
                { "Name": "Text", "Title": resources.Text, "Data": "DisplayText", "Width": "40%", "Sortable": false }
            ],
            allowRowSelection: function (data) { return canReadPII || data.IsPII == 0; },
            rememberRowSelection: true,
            limitRowSelection: variableSelector.limitRowCount,
            selectedRows: selectedVariables,
            style: "compact",
            quickFilter: !variableSelector.showFilters ? null
                : {
                    "AlwaysVisible": true,
                    "IncludeSelectedStates": true,
                    "Items": [
                        { "Label": resources.System, "AjaxParams": { "includeSystemVariables": true, "onlyOpenEnds": false, "onlySystem": true } },
                        { "Label": resources.Questions, "AjaxParams": { "includeSystemVariables": false, "onlyOpenEnds": false, "onlySystem": false } },
                        { "Label": resources.OpenEnd, "AjaxParams": { "includeSystemVariables": false, "onlyOpenEnds": true, "onlySystem": false } }
                    ]
                }
        });

        if (!variableSelector.showFilters) {
            var $selectionPanel = $(".v-selectionPanel");
            $(".h-variables-table .top").prepend($selectionPanel.css("float", "left"));
        }
    },
    bindEvents: function () {
        $(document).on("click", ".v-confirmButton", function () {
            var items = variableSelector.datatable.a4datatable("getSelectedItems");

            var orginalItems = _.filter(items, function (i) { return i.Id == undefined; });

            var newItems = _.filter(items, function (i) { return i.Id !== undefined; }).sort(function (x, y) {
                if (x.BlockPosition !== y.BlockPosition)
                    return x.BlockPosition - y.BlockPosition;

                if (x.QuestionPosition !== y.QuestionPosition)
                    return x.QuestionPosition - y.QuestionPosition;

                if (x.ColPos !== y.ColPos)
                    return x.ColPos - y.ColPos;

                if (x.RowPos !== y.RowPos)
                    return x.RowPos - y.RowPos;

                return x.Id - y.Id;
            });

            $(".v-selectedVariables").val(_.pluck(orginalItems.concat(newItems), "Name").join(","));
            $(".v-confirmed").val("true");
            modalDialog.close();
        });

        $(document).on("click", ".h-selectAllRows", function () {
            a4.callServerMethod(a4.getSurveyAction("GetVariablesNames", "Shared"), { includeSystemVariables: variableSelector.showSystemVariables, includeEditableSystemVariables: variableSelector.showEditableSystemVariables, excludePIIs : true },
            function (result) {
                variableSelector.datatable.a4datatable("option", "selectedRows", result.join());
            });
        });

        $(document).on("click", ".h-unselectAllRows", function () {
            variableSelector.datatable.a4datatable("option", "selectedRows", "");
        });
    }
}

$(document).ready(function () {
    var limit = parseInt($("#limitCount").val(), 10);
    variableSelector.surveyId = $("#SurveyId").val();
    variableSelector.limitRowCount = (limit > 0) ? limit : null;
    variableSelector.showFilters = ($("#showFilters").val() == 'true');
    variableSelector.showSystemVariables = ($("#showSystemVariables").val() == 'true');
    variableSelector.showEditableSystemVariables = ($("#showEditableSystemVariables").val() == 'true');
    variableSelector.onlyOpenEnds = ($("#onlyOpenEnds").val() == 'true');
    variableSelector.initializeDataTable();

    $(".v-selectionPanel").toggle(variableSelector.limitRowCount == null);
    variableSelector.bindEvents();
});